var /* ...*/
	rquickExpr = /^(?:\s*(<[\w\W]+>)[^>]*|#([\w-]*))$/,

	init = jQuery.fn.init = function( selector, context, root ) {
		var match, elem;

		// UCHWYT: $(""), $(null), $(undefined), $(false)
		if ( !selector ) {
			return this;
		}

		// Metoda init() akceptuje alternatywny parametr rootjQuery,
		// dlatego może obsługiwać jQuery.sub (gh-2101)
		root = root || rootjQuery;

		// Obsługa łańcuchów HTML
		if ( typeof selector === "string" ) {
			if ( selector[ 0 ] === "<" &&
				selector[ selector.length - 1 ] === ">" &&
				selector.length >= 3 ) {

				// Przyjęto, że łańcuchy zaczynające się i kończące znakami <> to kod HTML, a ponadto
				// pominięto sprawdzanie wyrażenia regularnego
				match = [ null, selector, null ];

			} else {
				match = rquickExpr.exec( selector );
			}

			// Dopasowanie kodu HTML lub sprawdzenie, czy nie określono żadnego kontekstu dla #id
			// 
			if ( match && ( match[ 1 ] || !context ) ) {

				// UCHWYT: $(html) -> $(array)
				if ( match[ 1 ] ) {
					context = context instanceof jQuery ? context[ 0 ] : context;

					// Opcja uruchamiania skryptów ma wartość true w celu zapewnienia zgodności wstecz
					// Celowo umożliwiono zgłoszenie błędu w wypadku braku parseHTML
					jQuery.merge( this, jQuery.parseHTML(
						match[ 1 ],
						context && context.nodeType ? context.ownerDocument || context : document,
						true
					) );
					/* 16 wierszy kodu */
					return this;

				// UCHWYT: $(#id)
				}/*...*/
			}/*...*/
		}/*...*/
	};
